local _, core = ...;
local MonDKP = core.MonDKP;

core.BossList = {
  MC = {
    "Lucifron", "Magmadar", "Gehennas",
    "Garr", "Baron Geddon", "Shazzrah", "Sulfuron Harbinger", 
    "Golemagg the Incinerator", "Majordomo Executus", "Ragnaros"
  },
  BWL = {
    "Razorgore the Untamed", "Vaelastrasz the Corrupt", "Broodlord Lashlayer",
    "Firemaw", "Ebonroc", "Flamegor", "Chromaggus", 
    "Nefarian"
  },
  AQ = {
    "The Prophet Skeram", "Battleguard Sartura", "Fankriss the Unyielding",
    "Princess Huhuran", "Twin Emperors", "C'Thun", 
    "Bug Family", "Viscidus", "Ouro"
  },
  NAXX = {
    "Anub'Rekhan", "Grand Widow Faerlina", "Maexxna",
    "Noth the Plaguebringer", "Heigan the Unclean", "Loatheb", 
    "Instructor Razuvious", "Gothik the Harvester", "The Four Horsemen",
    "Patchwerk", "Grobbulus", "Gluth", "Thaddius",
    "Sapphiron", "Kel'Thuzad"
  },
  ZG = {
    "Bloodlord Mandokir", "Gahz'ranka", "Hakkar", "High Priest Thekal", "High Priest Venoxis", "High Priestess Arlokk",
    "High Priestess Jeklik", "Jin'do the Hexxer", "High Priestess Mar'li", "Edge of Madness"
  },
  AQ20 = {
    "Ayamiss the Hunter", "Buru the Gorger", "General Rajaxx", "Kurinnaxx", "Moam", "Ossirian the Unscarred"
  },
  ONYXIA = {"Onyxia"},
  WORLD = {
    "Azuregos", "Lord Kazzak", "Emeriss", "Lethon", "Ysondre", "Taerar"
  }
}

core.ZoneList = {
  "Molten Core", "Blackwing Lair", "Temple of Ahn'Qiraj", "Naxxramas", "Zul'Gurub", "Ruins of Ahn'Qiraj", "Onyxia's Lair", "World Bosses"
}

core.L = {
  ADD                   = "Add",
  ADDED                 = "Added",
  ADDGUILDCONFIRM       = "Are you sure you'd like to add all guild members that are rank",
  ADDGUILDDKPTABLE      = "Add Guild to DKP Table",
  ADDGUILDDKPTABLETT    = "Adds all guild members of the selected rank that are not already part of the DKP table.",
  ADDGUILDMEMBERS       = "Add Guild Members",
  ADDNEGTTDESC          = "When checked, any player with negative DKP has their debt reduced by the above percentage. All others are reduced by above percentage. Unchecked, players in the negative are unaffected by the decay.",
  ADDNEGTTWARN          = "This checkbox ONLY effects the behavior of the above decay on negative DKP players.",
  ADDNEGVALUES          = "Add to Negative Values",
  ADDRAIDMEMBERS        = "Add Raid Members",
  ADDRAIDMEMBERSCONFIRM = "Are you sure you'd like to add missing raid members to DKP table?",
  ADDRAIDMEMBERSTTDESC  = "Add all raid/party members that are in guild to DKP table.",
  ADDREMDKPTABLEENTRIES = "Add/Remove DKP Table Entries",
  ADDTARGET             = "Add Target",
  ADDTARGETTODKPTABLE   = "Add Target to DKP Table",
  ADDTARGETTTDESC       = "Adds your current target, if a player, to the DKP table. This, unlike all other options, does not require the target to be in your guild.",
  ADDTOMAXROLL          = "Add to Max Roll",
  ADDTOMAXROLLTTDESC    = "Adds predetermined value to the maximum roll.",
  ADDTOMAXROLLTTWARN    = "eg: If you want your players max roll to be their max DKP + 500 with a range of 1 - MaxDKP set above, a player with 80 DKP will be expected to /random 1-580.",
  ADDTOSTANDBY          = "Add Selected Players to Standby List",
  ADJUSTDESC            = "Select individual players from the left (Shift+Click for multiple players) or click \"Select All Visible\" below and enter amount to adjust.\n\nScope can be adjusted with \"Show Raid Only\" below or on the \"Filters\" tab.",
  ADJUSTDKP             = "Adjust DKP",
  ADJUSTDKPTTDESC       = "Apply above entry to all selected players in the DKP table.",
  ADJUSTDKPTTWARN       = "This entry will be broadcasted to all online players in your guild.",
  ALL                   = "all",
  ALLCLASSES            = "All Classes",
  ALLOWNEGATIVEBIDDERS  = "Allow Negative Bidders",
  ALLOWNEGATIVEBIDTTDESC= "Allows a player to bid if their DKP is currently in the negative.",
  ALLTABLES             = "All of your tables are currently",
  ALREADYASSIGNED       = "That item is already assigned to that player.",
  AMONG                 = "among",
  ANDCHARGEITTO         = "and charge it to",
  APPDECAYTTDESC        = "Amount of DKP you wish to reduce DKP entries by as a weekly decay. This should be a positive number. If \"Selected Players Only\" is not selected below, it will apply to all entries.",
  APPDECAYTTWARN        = "Warning: Can not be undone.",
  APPLYDECAY            = "Apply Decay",
  AREYOUSURE            = "Are you sure you'd like to give",
  AREYOUSUREBROADCAST   = "Are you sure you'd like to broadcast DKP mode settings?",
  AREYOUSUREREASSIGN    = "Are you sure you'd like to reassign",
  ARTIFICIALINFLATION   = "Artificial Inflation",
  ARTINFLATTTDESC       = "Points to give to each player ON TOP of the DKP that is divided and distributed among them. This value is added to their earned DKP AFTER the banked value is divided.",
  AUTOAWARD             = "Auto Award DKP",
  AUTOAWARDTTDESC       = "Automatically awards Boss Kill Bonus DKP (set in Options tab) when a boss is killed.",
  AWARDBONUS            = "Award Bonus",
  AWARDBONUSTTDESC      = "Amount of DKP to give to the raid each time the below interval is met.",
  AWARDINTERVAL         = "Award Interval",
  AWARDINTERVALTTDESC   = "Time interval (in minutes) you want DKP to be awarded to the entire raid.",
  AWARDINTERVALTTWARN   = "eg. Entering 60 will award the raid (and standby, if checked below) the DKP amount in the \"Bonus\" field above every hour.",
  AWARDITEM             = "Award Item",
  AWARDITEMTO           = "Award item to",
  BALANCE               = "Balance",
  BCASTCOMPLETED        = "All broadcasts have completed.",
  BCASTDKPHIST          = "Broadcasting DKP History",
  BCASTDKPHISTBTN       = "Broadcast DKP History",
  BCASTDKPHISTCONF      = "Are you sure you'd like to broadcast your DKP History table?",
  BCASTDKPTABLEBTN      = "Broadcast DKP Table",
  BCASTLOOTHIST         = "Broadcasting Loot History",
  BCASTLOOTHISTBTN      = "Broadcast Loot History",
  BCASTLOOTTABLECONF    = "Are you sure you'd like to broadcast your Loot History table?",
  BCASTMINBIDCONFIRM    = "Are you sure you'd like to broadcast your minimum bid settings to all officers?",
  BCASTVALUES           = "Broadcast Values",
  BCASTVALUESTTDESC     = "Broadcast above minimum bid values to all officers. This will also broadcast any custom values set for specific items in the bid window.",
  BCASTVALUESTTWARN     = "Current values will not be overwritten. Receiving this broadcast will update values already set or add values that don't exist. Any values they may have that are not sent will remain unchanged.",
  BELT                  = "Belt",
  BESTPRACTICES         = "|cffff0000OFFICERS PLEASE READ!!|r: This update contains no new features or updates. It is a preparatory update aimed at officers. 2.0 will feature an extensive overhaul of the system, how it keeps records and broadcasts them. It is crucially important that migration instructions are followed to prevent duplicate data leading to dramatically incorrect databases. In the next update, Officers will be prompted with instructions to migrate their current tables. This can ONLY be executed by ONE officer. All remaining officers will be prompted to delete their data to accept the migrated data from the selected migrating officer. Please coordinate accordingly over the next few days to avoid issues. Once the data is broadcasted, if incorrect, is difficult to correct.\n\nWhen an officer chooses to migrate, the GM public note will be updated with that officers name to indicate to all other officers that the database has already been migrated, asking them if they would like to delete their current data (PLEASE backup your SavedVariables file prior, just in case), and instructing them to get a broadcast from that officer to complete the process. Forcing a sync can be completed by clicking the table status indicator on the bottom left of the main GUI. Once this migration has occurred, all data is persistent. In the event the migration gets somehow bunked, the only way to revert is to have all officers that have received broadcasts delete their saved variables file and put a backed up copy simultaneously. This must be done simultaneously because if you delete it and log in, if an officer has the new indexed tables, they'll simply broadcast it back to you immediately. Once migration has completed for all officers, the GMs note indicating the migrating officer can be deleted. ONLY do this once you're certain all officers have the new tables.\n\nAdditionally, all members must update to 2.0 or later. Older versions will not be compatible.",
  BID                   = "Bid",
  BIDACCEPTEDFILTER     = "Your bid was Accepted.",
  BIDCANCELLED          = "Your bid has been canceled.",
  BIDDENIEDEXCEEDMAX    = "Bid Denied! Your bid exceeded the maximum bid value of",
  BIDDENIEDFILTER       = "Bid Denied!",
  BIDDENIEDINVALID      = "Bid Denied! Invalid Bid Received.",
  BIDDENIEDMINBID       = "Bid Denied! Below minimum bid of",
  BIDDENIEDNEGATIVE     = "Bid Denied! Your DKP is in the negative",
  BIDDENIEDNOVALUE      = "Bid Denied! No value given for bid.",
  BIDDENIEDONLYHAVE     = "Bid Denied! You only have",
  BIDDINGCLOSED         = "Bidding Closed!",
  BIDHELP               = "Bid on current item when bidding is opened.",
  BIDMETHOD             = "Bid Method",
  BIDTIMER              = "Bid Timer",
  BIDTIMERDEFAULTTTDESC = "Default time used for bid timer in seconds.",
  BIDTIMERTTDESC        = "How long bidding for this item will stay open in seconds.",
  BIDTIMERTTWARN        = "Default can be set in Options tab.",
  BIDWASACCEPTED        = "Your bid was Accepted.",
  BIDWHISPARENOW        = "Bid whispers are now",
  BLOCKOODBROADCAST     = "You can not broadcast out of date tables. Doing so would result in unrecoverable data loss. If you are absolutely positive you have the most up to date data, deleting the tag from the guild leader's public note will resolve this.",
  BONUS                 = "Bonus",
  BONUSAWARDED          = "Bonus Awarded",
  BOOTS                 = "Boots",
  BOSS                  = "Boss",
  BOSSKILLBONUS         = "Boss Kill Bonus",
  BOSSKILLBONUSTTDESC   = "Bonus given for killing a boss.",
  BRACERS               = "Bracers",
  BROADCASTDKPTABLECONF = "Are you sure you'd like to broadcast all tables? This does NOT merge your table with others. It will completely overwrite the entire guilds tables with exact copies of yours.",
  BROADCASTHEADER       = "Below button is to be used to sync up out of date users. Ideally at the beginning or after a raid, or to update someone that was offline for a raid. Do not use this regularly after each entry is made. All adjustments or loot awards are broadcasted individually. You can not make any adjustments while this is broadcasting (can take a few minutes depending on table sizes).",
  BROADCASTSETTINGS     = "Broadcast Settings",
  BROADCASTSETTTDESC    = "Broadcasts all DKP related settings including the above DKP mode parameters, as well as item values and bonus values (set in Options).",
  CANCEL                = "Cancel",
  CASTERDPS             = "Caster DPS",
  CHEST                 = "Chest",
  CLASS                 = "Class",
  CLASSFILTER           = "Class Filters",
  CLEARBIDWINDOW        = "Clear Window",
  CLEARBIDWINDOWTTDESC  = "Clears all item information and submitted bids from window.",
  CLEARSTANDBY          = "Clear Standby List",
  CLICKQUERYGUILD       = "Click to query the guild to find which\nofficers that are online have updated tables.",
  CLOAK                 = "Cloak",
  CLOSE                 = "Close",
  CLOSEDBIDINPROGRESS   = "Bidding window closed with a bid in progress! Type /dkp bid to reopen to current bid session.",
  COMMANDCHANNELS       = "Command Channels",
  COMMANDCHANNELSTTDESC = "Select the channels you wish to open to receive !bid and !dkp commands. You can select any combination of the three to open. All received commands, regardless of the channel, will be responded to with a whisper.",
  CONFAWARD             = "Confirm Award",
  CONFIRM               = "Confirm",
  CONFIRMADDTARGET      = "Are you sure you'd like to add",
  CONFIRMAWARD          = "Are you sure you'd like to award",
  CONFIRMDECAY          = "Are you sure you'd like to decay",
  CONFIRMDELETEENTRY1   = "Are you sure you'd like to delete the entry",
  CONFIRMREMOVESELECT   = "Are you sure you'd like to remove",
  CONFIRMWHITELIST      = "Are you sure you'd like to add the selected players to the whitelist?",
  CONFIRMWHITELISTCLEAR = "Are you sure you'd like to clear the whitelist?",
  CONGRATS              = "Congrats",
  CONTACTOFFICER        = "Please contact an officer shown above as \"Up to Date\" to have your tables updated.",
  CONTINUERAID          = "Continue Raid",
  CORRECTINGERROR       = "Correcting Error",
  COSTAUTOUPDATE        = "Cost Auto Update",
  COSTAUTOUPDATETTDESC  = "Select what you'd like the item cost to be automatically updated to during a bid session.\n\n|CFFFF0000First Bidder|r: This will update the cost of the item at the bottom of the bid window to the highest bidder.\n\n|CFFFF0000Second Bidder|r: This will update the cost of the item at the bottom of the bid window to either the second highest bidder or, if there is only one bidder, the minimum bid value.\n\nFor each, the cost is always editable on the fly.",
  COSTAUTOUPDATEVALUE   = "Cost Auto Update Value",
  CREATEDMAINTAIN       = "created and maintained by",
  CREATERAIDTIMER       = "Creates Raid Timer (Officers Only) (eg. /dkp timer 120 Pizza Break!)",
  CURRENTLYHAS          = "currently has",
  CURRENTLYSYNCING      = "You are currently syncing tables. Please wait until completed to continue.",
  CURRNOTINGUILD        = "You are not currently in a guild. DKP status can not be queried.",
  CUSTOM                = "Custom",
  CUSTOMMINBID          = "Custom Minimum Bid",
  CUSTOMMINBIDTTDESC    = "You have set a custom minimum bid for this item. Uncheck this box to use the standard bid for this item type (set in Options tab).",
  CUSTOMMINBIDTTWARN    = "Starting bid with this unchecked will delete the custom minimum bid value from the database.",
  DAY                   = "day",
  DAYS                  = "days",
  DECAYAMOUNT           = "Decay Amount",
  DECAYPERCENTAGE       = "Decay Percentage",
  DECAYPERCENTAGETTDESC = "Percentage to reduce all DKP values by for routine decay.",
  DECAYPERCENTAGETTWARN = "NOT a negative number.",
  DEFAULTDKPAWARDVALUES = "Default DKP Award Values",
  DEFAULTITEMCOSTS      = "Default Item Costs",
  DEFAULTMINBIDVALUES   = "Default Minimum Bid Values",
  DEFAULTSETSAVED       = "Default settings saved.",
  DEFAULTSETTINGS       = "Default Settings",
  DELETEDKPENTRY        = "Delete DKP Entry",
  DELETEENTRYREFUNDCONF = "Any DKP impacted by this entry will be refunded/removed from each player listed.",
  DISABLED              = "Disabled",
  DISTRIBUTEALLDKPCONF  = "Distribute DKP to all players in the raid?",
  DISTRIBUTEDKP         = "Distribute DKP",
  DISTRUBUTEBANKED      = "Distribute banked DKP to all raid members evenly after looting has completed for the current boss.",
  DKP                   = "DKP",
  DKPADJUST             = "DKP Adjust",
  DKPADJUSTBY           = "DKP Adjusted by",
  DKPAVAILABLE          = "DKP available",
  DKPAWARDHELP          = "Manually Award Item (Officers Only) (eg. /dkp award roeshambo 100 [item link])",
  DKPBROADCASTED        = "DKP Database Broadcasted",
  DKPCMDHELP            = "Returns your current DKP (Or DKP of <player name>)",
  DKPDATAUPDATEDBY      = "DKP database updated by",
  DKPENTRIESBY          = "DKP entries by",
  DKPEXPORTHELP         = "Opens window to export all DKP information to HTML, CSV or XML. (More export implementations to come)",
  DKPHISTCASTCOMP       = "DKP History Broadcast Complete",
  DKPHISTLIMITTTDESC    = "Maximum DKP history entries stored.",
  DKPHISTLIMITTTWARN    = "Warning: If you reduce this below the number of currently stored entries, the oldest will be deleted to meet the limit.",
  DKPHISTORY            = "DKP History",
  DKPHISTORYLIMIT       = "DKP History Limit",
  DKPHISTORYUPDATECOMP  = "DKP history update complete.",
  DKPHISTRECORDS        = "dkp history records",
  DKPHISTUPDATEPROG     = "DKP history update in progress",
  DKPLAUNCH             = "Launches DKP Window",
  DKPLOCKOUT            = "Displays the next reset for each raid size (3 day, 5 day and 7 day lockouts)",
  DKPMINBID             = "DKP Minimum bid",
  DKPMODES              = "DKP Modes",
  DKPMODESENTCONF       = "DKP Mode Settings Sent",
  DKPMODESFOOTER        = "If any changes are made to this window, your UI |cffff0000MUST|r be reloaded. You will receive errors if a reload is not completed. You will be prompted to do so when the window closes.",
  DKPMODESHELP          = "Opens DKP Modes Window (Officers Only)",
  DKPMODESTTDESC        = "Select the DKP mode to be used in the bidding window. Mode descriptions will be displayed above on selection. Reload after selecting your mode.",
  DKPMODESTTDESC2       = "Configure what type of DKP system you will be using. High level of variability in each mode.",
  DKPMODESTTWARN        = "Your interface MUST be reloaded if any settings are changed. You will be prompted to do so when closing. Failure to do so will cause errors.",
  DKPPRICE              = "DKP price",
  DKPRESETPOS           = "Resets DKP Window Position/Size",
  DKPROUNDING           = "DKP Rounding",
  DKPROUNDINGTTDESC     = "Set how many decimal places you wish to use in your DKP system. Zero would mean round integers (no decimal points)",
  DKPSTATUS             = "DKP Status",
  DKPTOFOLLOWING        = "DKP to the following players",
  DKPWASACCEPTED        = "DKP was Accepted",
  DONTSHOW              = "Don't show again for this version.",
  ELEMENTAL             = "Elemental",
  ENABLED               = "Enabled",
  ENDBIDDING            = "End Bidding",
  ENDCURRAIDCONFIRM     = "Are you sure you wish to end the current raid?",
  ENDRAID               = "End Raid",
  ENHANCEMENT           = "Enhancement",
  ENTEROTHERREASONHERE  = "Enter Other Reason Here",
  ENTRIESSELECTED       = "Entries Selected",
  ENTRIESSHOWN          = "Entries Shown",
  ENTRYSELECTED         = "Entry Selected",
  ERROR                 = "Error",
  ERRORPROCESSING       = "Error processing command",
  EXPECTEDROLL          = "Expected Roll",
  FERAL                 = "Feral Combat",
  FILTERS               = "Filters",
  FIRSTBIDDER           = "First Bidder",
  FIRSTKILL             = "First Kill",
  FOR                   = "for",
  FORBACKSLOT           = "for back slot items.",
  FORCHESTSLOT          = "for chest slot items.",
  FORFEETSLOT           = "for feet slot items.",
  FORFINGERSLOT         = "for finger slot items.",
  FORHANDSLOT           = "for hand slot items.",
  FORHEADSLOT           = "for head slot items.",
  FORLEGSLOT            = "for leg slot items.",
  FORNECKSLOT           = "for neck slot items.",
  FOROFFHANDSLOT        = "for off-hand items (Shields, caster off-hands).",
  FORONEHANDSLOT        = "for one-handed weapons.",
  FOROTHERSLOT          = "for all other items that do not fall into the above categories (Heads, Hearts, Hunter Leaf etc.)",
  FORPLAYERS            = "for the following players",
  FORRANGESLOT          = "for range slot items (Bows, guns, wands, relics).",
  FORREASON             = "for reason",
  FORSHOULDERSLOT       = "for shoulder slot items.",
  FORTRINKETSLOT        = "for trinket slot items.",
  FORTWOHANDSLOT        = "for two-handed weapons.",
  FORWAISTSLOT          = "for waist slot items.",
  FORWRISTSLOT          = "for wrist slot items.",
  FROMSTANDBYLIST       = "from Standby List",
  GENDKPHIST            = "Generate DKP History",
  GENDKPTABLE           = "Generate DKP Table",
  GENLOOTHIST           = "Generate Loot History",
  GIVEENDBONUS          = "Give End Bonus",
  GIVEENDBONUSTTDESC    = "Selecting this will award everyone in the raid (and standby, if selected below) the \"Raid Completion\" bonus when you end the Raid.",
  GIVEONTIMEBONUS       = "Give On Time Bonus",
  GIVEONTIMETTDESC      = "Selecting this will award everyone in the raid (and standby, if selected below) the \"On Time\" bonus when you Initialize the Raid.",
  GUILD                 = "Guild",
  HANDS                 = "Hands",
  HEAD                  = "Head",
  HEALER                = "Healer",
  HELPINFO              = "Shows Help Info",
  HIDDEN                = "hidden",
  HIDEBIDTIMER          = "Hide Bid Timer",
  HOLY                  = "Holy",
  HOUR                  = "hour",
  HOURS                 = "hours",
  IN                    = "in",
  INCLUDESBYTTDESC      = "Includes players on the standby list when automatically awarding Boss Kill DKP activated above.",
  INCLUDESBYTTWARN      = "If Standby Opt In is active, DKP is awarded to the raid immediately, while the standby list award is delayed until after the two minute opt in window expires.",
  INCLUDESTANDBY        = "Include Standby",
  INCLUDESTANDBYLIST    = "Include Standby List",
  INCLUDESTANDBYTTDESC  = "Selecting this will include the Standby list in all automatic DKP distributions.",
  INCLUDESTANDBYTTWARN  = "Create standby list by selecting players on the DKP table that are not in the raid, right clicking > Manage Standby List > Add Selected Players to Standby List.",
  INCREMENTINVALIDWARN  = "Increment is an invalid number.",
  INCSTANDBYLISTTTDESC  = "Includes players in the standby list in distribution.",
  INCSTANDBYLISTTTWARN  = "This will yield smaller values given to players in the raid.",
  INFLATION             = "Inflation",
  INITRAID              = "Initialize Raid",
  INITRAIDTTDESC        = "Begins the raid timer to award DKP based on the time increment you've given above. This can be initialized by any officer in the raid, but only the raid leader will give the DKP award the checked conditions are met.",
  INITRAIDTTWARN        = "This is broadcasted to all officers in the raid. Each officer will have a timer but ONLY the raid leader will grant the award. If an event occurs (offline, reload etc) that causes the leader to lose their timer, give raid leader to another officer that still has their timer running to prevent interruption.",
  INPARTYRAID           = "In Party/Raid",
  INTEGER               = "Integer",
  INTERVAL              = "Interval",
  INVALIDBOSSNAME       = "Invalid Boss Name",
  INVALIDITEMCOST       = "Can not award item. Invalid Item Cost",
  INVALIDITEMLINK       = "Can not award item. Invalid item link",
  INVALIDMINBIDENTRY    = "Invalid Minimum Bid Entry at",
  INVALIDOPTIONENTRY    = "Invalid Options Entry at",
  INVALIDPLAYER         = "Invalid Player. You are not listed in the DKP table.",
  INVALIDROLLPARAM      = "You have set an invalid roll parameter. Please revise your settings.",
  INVALIDROLLRANGE      = "You have set an invalid roll range. Please revise your settings.",
  INVALIDTARGETPLAYER   = "Can not award item. Invalid Target Player",
  INVALIDTIMER          = "Invalid Timer",
  INVITE                = "Invite",
  INVITESELECTED        = "Invite Selected to Raid",
  ITEM                  = "Item",
  ITEMCOST              = "Item Cost",
  ITEMCOSTTTDESC        = "DKP to charge player for item.",
  ITEMCOSTTYPES         = "Item Cost Types",
  ITEMCOSTTYPESTTDESC   = "Select the type of value that is used for item costs (what the player pays for an item); integer or percent. These values are set in \"Options\" tab.\n\n|CFFFF0000Integer|r: Item costs are integers (decimals are rounded to the decimal place indicated by \"DKP Rounding\" below). ex: 100 DKP.\n\n|CFFFF0000Percent|r: Item costs are a percentage of the winning players total DKP. ex: Player has 1000 DKP, item cost is 20%. Therefore, item cost is 200 DKP for that player.",
  LEGS                  = "Legs",
  LIFETIMEEARNED        = "Lifetime Earned",
  LIFETIMESPENT         = "Lifetime Spent",
  LOAD                  = "Load",
  LOAD50MORE            = "Load 50 More...",
  LOADED                = "Loaded",
  LOOTBANKED            = "Loot Banked",
  LOOTHISTCASTCOMP      = "Loot History Broadcast Complete",
  LOOTHISTINST1         = "Shift+Click to link item\nAlt+Click to link line",
  LOOTHISTINST2         = "Right Click to edit entry",
  LOOTHISTINST3         = "Right Click To Delete Entry",
  LOOTHISTLIMITTTDESC   = "Maximum loot history entries stored.",
  LOOTHISTLIMITTTWARN   = "Warning: If you reduce this below the number of currently stored entries, the oldest will be deleted to meet the limit.",
  LOOTHISTORY           = "Loot History",
  LOOTHISTORYLIMIT      = "Loot History Limit",
  LOOTHISTORYUPDATECOMP = "Loot history update complete.",
  LOOTHISTRECORDS       = "loot history records and",
  LOOTHISTUPDATEPROG    = "Loot history update in progress",
  MAINGUISIZE           = "Main GUI Size",
  MANAGE                = "Manage",
  MANAGECORELIST        = "Manage Core Raider List",
  MANAGEDKP             = "Manage DKP Listings",
  MANAGELISTS           = "Manage Lists",
  MANAGESTANDBY         = "Manage Standby List",
  MANUALLYDENIED        = "has been Denied.",
  MAX                   = "Max",
  MAXIMUMBID            = "Maximum Bid",
  MAXIMUMBIDTTDESC      = "This is a hardline maximum bid allowed. If a player attempts to bid higher than this value, their bid will be denied. Set to 0 if you do not wish to have a max.",
  MAXIMUMROLL           = "Maximum Roll",
  MAXIMUMROLLTTDESC     = "Set the maximum roll to be used. Leave blank to use players max DKP as max roll.",
  MAXIMUMROLLTTWARN     = "Only leave blank for max DKP if \"Use Percentage\" is unchecked. If it is checked, use 100%.",
  MELEEDPS              = "Melee DPS",
  MIN                   = "Min",
  MINBIDDESCRIPTION     = "With Minimum Bid Values all slots (or individual items) are assigned a minimum value. Anyone that submits a bid must bid at that value or greater.\n\nEx: |cffa335ee|Hitem:16865::::::::120:577::::::|h[Breastplate of Might]|h|r drops and has a minimum bid value of 50 DKP. Each player that want's it sends \"!bid 50\" (or greater) through one of the opened channels (selected below) without exceeding their available DKP (unless sub-zero DKP is activated). The player with the highest bid wins and is charged either the minimum DKP value or the value that the 2nd highest bidder submitted. Read tooltips for additional information.",
  MINBIDTTDESC          = "Minimum bid value that will be accepted.",
  MINBIDTTEXT           = "If you enter a value other than what is set in Options, that custom value will be stored for that specific item.",
  MINBIDTTWARN          = "Defaults can be set in Options tab.",
  MINBIDVALUESHEAD      = "Minimum Bid Values",
  MINBIDVALUESRECEIVED  = "Minimum Bid Values Received from",
  MINBIDVALUESSENT      = "Minimum Bid Values Sent",
  MINIMUMBID            = "Minimum Bid",
  MINIMUMROLL           = "Minimum Roll",
  MINIMUMROLLTTDESC     = "Set the minimum roll to be used.",
  MINUTE                = "minute",
  MINUTES               = "minutes",
  MONDKPSCALESIZE       = "Monolith DKP Scale Size",
  MONDKPSCALESIZETTDESC = "Scale of the Monolith DKP window. Click \"Save Settings\" to change size to set value.",
  MONDKPSCALESIZETTWARN = "May require a /reload after saving if another Addon is used that modifies UI scales (ex. TukUI, ElvUI etc...)",
  MORE                  = "more",
  MOVEBIDTIMER          = "Move Bid Timer",
  MOVEME                = "Move Me!",
  MULTIPLESELECT        = "Multiple Selections",
  NAMENOTFOUND          = "Your name was not found in the DKP database.",
  NECK                  = "Neck",
  NEWBOSSKILLBONUS      = "New Boss Kill Bonus",
  NEWBOSSKILLTTDESC     = "Bonus given for first time boss kills during progression raids.",
  NO                    = "No",
  NOBIDINPROGRESS       = "No Bids in Progress",
  NOCORERAIDTEAM        = "There are no players in your core raid team.",
  NOENTRIESSELECTED     = "No entries selected.",
  NOGUILD               = "No Guild",
  NOITEMORITEMCOST      = "No item cost and/or item to bid on!",
  NOMINBIDORITEM        = "No minimum bid and/or item to bid on!",
  NONE                  = "None",
  NOPARTYORRAID         = "You are not in a party or raid.",
  NOPERMISSION          = "You do not have permission to access that feature.",
  NOPLAYERINSTANDBY     = "There are no players in the standby group.",
  NOPLAYERSSELECTED     = "No player selected to transfer loot.",
  NOPLAYERTARGETED      = "No player targeted.",
  NOPOINTSTODISTRIBUTE  = "There are no points to distribute.",
  NORANKSELECTED        = "No rank is selected.",
  NOROLEDETECTED        = "No Role Detected",
  NOSPECREPORTED        = "No Spec Reported",
  NOTANOFFICER          = "is not an officer. You may only add ranks that have \"Edit Officer Note\" permissions in guild settings.",
  NOTETOOLONG           = "Guild Leaders public note was too long. Truncated note to fit DKP Table timestamp. (31 character max)",
  NOTIFICATIONSLIKETHIS = "Notifications like this are now",
  NOTINGUILD            = "Not in Guild",
  NOTINRAID             = "You are not in a raid.",
  NOTINRAIDFILTER       = "Not In Raid",
  NOTINRAIDPARTY        = "You are not in a raid party.",
  NOTSUBMITTEDBID       = "You have not submitted a bid.",
  OFF                   = "off",
  OFFHAND               = "Off-Hand",
  OFFHANDITEMS          = "Off-Hand Items",
  OK                    = "OK",
  ON                    = "on",
  ONEHANDED             = "One-Handed",
  ONEHANDEDWEAPONS      = "One-Handed Weapons",
  ONETABLEOOD           = "One or more of your tables are currently",
  ONLINE                = "Online",
  ONLYONEROLLWARN       = "Only one roll can be accepted!",
  ONLYPARTYRAID         = "Only Party or Raid",
  ONTIMEBONUS           = "On Time Bonus",
  ONTIMEBONUSTTDESC     = "Bonus given as for being present for a raid on time.",
  OODDKPHISTORYDELETE   = "has attempted to delete an item from an out of date DKP history Table. This can cause irreversable damage to your DKP table. Would you like to accept?",
  OODDKPHISTORYENTRY    = "has broadcast an entry from out of date DKP History Table. This can cause irreversable damage to your DKP History table. Would you like to accept?",
  OODDKPHISTORYTABLE    = "has broadcast an out of date DKP History Table. This can cause irreversable damage to your DKP History table. Would you like to accept?",
  OODDKPTABLEBROADCAST  = "has broadcast an out of date DKP Table. This can cause irreversable damage to your DKP table. Would you like to accept?",
  OODLOGSYNC            = "has broadcast an out of date Loot History Table. This can cause irreversable damage to your Loot History table. Would you like to accept?",
  OODLOOTHISTORYDELETE  = "has deleted an item from an outdated Loot History table. This could cause the wrong item in your table to be deleted. Would you like to accept?",
  OODLOOTTABLEITEM      = "has attempted to update an item from an out of date Loot Table. This can cause irreversable damage to your DKP table. Would you like to accept?",
  OPENBIDWINDOWHELP     = "Opens Bid Window (Officers Only) (eg. /dkp bid [item link])",
  OPENCHANNELS          = "Open Channels",
  OPTIONS               = "Options",
  OR                    = "or",
  ORABOVE               = "or above?",
  OTHER                 = "Other",
  OTHERREASONVALIDATE   = "No Other - Reason Selected",
  OUTDATEMODIFYWARN     = "You are attempting to modify an outdated DKP table. This may inadvertently corrupt data for the officers that have the most recent tables.\n\n Are you sure you would like to do this?",
  OUTOFDATE             = "out-of-date",
  OUTOFDATEANNOUNCE     = "Your version of Monolith DKP is out-of-date. Please update on Curse/Twitch or WoWInterface to ensure there are no compatibility issues.",
  PAUSERAID             = "Pause Raid",
  PAUSERAIDTTDESC       = "This pauses a raid timer if the leader decides the timer should be halted for breaks.",
  PAUSERAIDTTWARN       = "Can be resumed by clicking \"Continue Raid\".",
  PERCENT               = "Percent",
  PERCENTCOST           = "Percentage cost",
  PLAYER                = "Player",
  PLAYERCOST            = "player cost [item link]",
  PLAYERNAME            = "player name",
  PLAYERNOTFOUND        = "That player was not found.",
  PLAYERREASONVALIDATE  = "No Player or Reason Selected",
  PLAYERRECORDS         = "player records",
  PLAYERROLL            = "Player Roll",
  PLAYERS               = "player(s)",
  PLAYERSFORREASON      = "players for reason",
  PLAYERVALIDATE        = "No Player Selected",
  PLEASEUSENUMS         = "Please use numbers.",
  POINTS                = "Points",
  POINTSTTDESC          = "Enter amount of DKP to be distributed to selected players on the DKP table. Default values can be changed in the \"Options\" tab below.",
  POINTSTTWARN          = "Use a negative number to remove DKP from selected players.",
  POPOUTTIMER           = "Pop Out Raid Timer",
  POPOUTTIMERDESC       = "Pops out the raid timer to a separate compact window.",
  POSITIONRESET         = "Window Position Reset",
  PROTECTION            = "Protection",
  PURGECONFIRM          = "Are you sure you wish to purge the DKP list?",
  PURGELIST             = "Purge DKP List",
  PURGELISTTTDESC       = "Purges DKP list of all players that have zero DKP and no DKP history.",
  RAID                  = "Raid",
  RAIDCOMPLETEBONUSTT   = "Bonus given to everyone that attends a raid through completion.",
  RAIDCOMPLETIONBONUS   = "Raid Completion Bonus",
  RAIDDKPADJUSTBY       = "Raid DKP Adjusted by",
  RAIDENDED             = "Raid Ended",
  RAIDPAUSE             = "Raid has been paused at",
  RAIDPAUSED            = "Raid Paused",
  RAIDRESUME            = "Raid has been resumed!",
  RAIDSTART             = "Raid timer has started!",
  RAIDTIMER             = "Raid Timer",
  RAIDTIMERBONUSCONFIRM = "Are you sure you'd like to apply the On Time bonus to this raid?",
  RAIDTIMERCONCLUDE     = "Raid timer has been concluded after",
  RANGE                 = "Range",
  RANGEDPS              = "Range DPS",
  RANK                  = "Rank",
  RANKLIST              = "Rank List",
  RANKLISTTTDESC        = "Select a rank and click \"Add Guild Members\" to add all guild members of the selected rank to the DKP table.",
  REASON                = "Reason",
  REASONFORADJUSTMENT   = "Reason for Adjustment",
  REASONTTDESC          = "Select reason for DKP adjustment. If \"Boss Kill Bonus\" or \"New Boss Kill Bonus\" is selected, an additional dropdown will be created to select the zone and boss. \"Other\" will create a textbox for you to enter a custom reason.",
  REASONTTWARN          = "When a boss is killed, the appropriate zone and boss will be auto-selected for you.",
  REASSIGNSELECTED      = "Reassign to Selected Player",
  RECENTHISTORYFOR      = "Recent History for",
  RELOADUICONFIRM       = "For these settings to take effect, we need to reload your UI. Would you like to do this now?",
  RELOADUIFORSETTINGS   = "has updated the DKP definitions. Do you wish to reload your UI to reflect these changes?",
  REMOVE                = "Remove",
  REMOVEENTRIES         = "Remove Entries",
  REMOVEENTRY           = "Remove Entry",
  REMOVEFROMSTANDBY     = "Remove Selected Players from Standby List",
  REMOVESELECTEDENTRIES = "Remove Selected Entries",
  REMSELENTRIESTTDESC   = "Removes selected players from the DKP table. All reference of that player will remain (DKP History and Loot History) but their name will appear gray.",
  REMSELENTRIESTTWARN   = "Warning: This action is permanent.",
  REQUESTTABLESOFFICER  = "Request updated tables from an officer.",
  RESETPREVCONFIRM      = "Are you sure you'd like to reset previous DKP?",
  RESETPREVDKP          = "Reset Previous DKP",
  RESETPREVDKPTTDESC    = "Resets the previous DKP counter to their current DKP (small gray +/- numbers next to each players current DKP). This does not effect functionality in any way. Just a reference of how much each player has earned/spent since you last reset it.",
  RESETPREVDKPTTWARN    = "Recommended to reset in regular intervals (weekly, monthly etc). This is a QOL feature and does not impact functionality.",
  RESETPREVIOUS         = "Reset Previous",
  RESETSIN              = "resets in",
  RESTORATION           = "Restoration",
  RETRIBUTION           = "Retribution",
  RINGS                 = "Rings",
  ROLE                  = "Role",
  ROLLBIDDINGHEAD       = "Roll Based Bidding",
  ROLLDESCRIPTION       = "With roll based bidding, you have multiple options for parameters. You can select the type of rolls you plan to use below. The options you set will not be parameters in whether a roll is accepted or denied. But will rather display the expected roll values in the bid window for review. You can right click their roll and remove if it doesn't meet the proper parameters.",
  ROLLFOR               = "Roll for",
  ROLLNOTACCEPTED       = "Your roll was not accepted. You only have",
  ROLLRANGE             = "Roll Range",
  ROLLSETTINGS          = "Roll Settings",
  SAVESETTINGS          = "Save Settings",
  SEARCH                = "Search   ",
  SEARCHDESC            = "Filters DKP list. Searches against Name, Class, Spec, Rank and Role.",
  SECONDBIDDER          = "Second Bidder",
  SECONDS               = "Seconds",
  SELECTALL             = "Select All",
  SELECTALLVISIBLE      = "Select All Visible",
  SELECTBOSS            = "Select Boss",
  SELECTED              = "selected",
  SELECTRANK            = "Select Rank",
  SELECTREASON          = "Select Reason",
  SELPLAYERSONLY        = "Selected Players Only",
  SELPLAYERSTTDESC      = "Applies the above DKP Decay to |cffff0000ONLY|r selected players on the DKP table",
  SELPLAYERSTTWARN      = "Useful to apply a decay to players beyond a threshold.",
  SENDWHITELIST         = "Send Whitelist",
  SENDWHITELISTTTDESC   = "Broadcasts your whitelist to all officers.",
  SENDWHITELISTTTWARN   = "Recommended you do this when all officers are online. If an officer does not receive this whitelist, they will have full officer permissions. They will not, however, be able to broadcast their information to other officers. You will be notified if they attempt to. If you receive that notification, Send the whitelist and their permissions will be removed.",
  SETWHITELIST          = "Set Whitelist",
  SETWHITELISTTTDESC1   = "Adds selected officers from the DKP table to the whitelist. Whitelist is used to |cffff0000limit|r the officers that have permissions to modify DKP values.",
  SETWHITELISTTTDESC2   = "Using this option with no players selected will clear your whitelist.",
  SETWHITELISTTTWARN    = "Only officers can be whitelisted. This option is used exclusively to restrict which officers have officer rights within this addon. If you wish for all officers to have permission, leave the whitelist empty.",
  SHADOW                = "Shadow",
  SHOULDERS             = "Shoulders",
  SLASHCOMMANDLIST      = "List of slash commands",
  SPEC                  = "Spec",
  STANDBYOPTIN          = "Standby Opt In",
  STANDBYOPTINBEGIN     = " has been killed. Please post !standby (or !standby Mains_Name if on an alt, spelling must be precise.) to Guild chat to receive DKP. Opt in will expire in 120 seconds.",
  STANDBYOPTINEND       = "Standby Opt in has expired for: ",
  STANDBYOPTINTTDESC    = "Announce to guild after a boss is killed requesting those on standby to opt in by typing !standby or !standby NAME (if on an alt) into GUILD chat. Opt in session will remain open for two minutes. Standby list is cleared after each boss kill prior to announcement of kill.",
  STANDBYOPTINTTWARN    = "If automatic DKP distribution on boss kill is active, the automatic distribution for the standby list will occur when the two minute opt in timer expires.",
  STARTBIDDING          = "Start Bidding",
  STARTBIDDINGTTDESC    = "Begins bidding for current item. Bids will only be accepted while this is running.",
  STARTBIDDINGTTWARN    = "Bidding duration can be set in \"Bid Timer\" box. Starting a second bid session for an item will not clear previous bids (for use if someone snipes a bid last second).",
  STATIC                = "Static",
  STATICDESCRIPTION     = "With Static Item Values all slots (or individual items) are assigned a static value. A bid is submitted by each player (with !bid) that desires the item, and the player with the highest available DKP wins. Cost value options are \"Integer\" or \"Percent\".\n\nEx: |cffa335ee|Hitem:19143::::::::120:577::::::|h[Flameguard Gauntlets]|h|r drops and has a static value of 50 DKP. Each player that want's it uses \"!bid\" through one of the opened channels (selected below). The player with the highest available DKP wins and is charged that static value. Read tooltips for additional information.",
  STATICITEMVALUESHEAD  = "Static Item Values",
  SUBMITBUGS            = "for help and submit any bugs",
  SUBZEROBIDDING        = "Sub Zero Bidding",
  SUBZEROBIDDINGTTDESC  = "Allows players to bid if they don't have enough DKP or bid higher than their available DKP (depending on mode settings).\n\n|cffff0000Minimum Bid Values|r: Allows players to bid more dkp than they have, up to the Max Bid (set below) allowing them to go into the negative.\n\n|cffff0000Others|r: Allows player to submit a bid even if their available DKP is exceeded by the cost of the item.",
  SUPPRESSBIDWHISP      = "Supress Bid Whispers",
  SUPPRESSNOTIFICATIONS = "Supress Addon Notifications",
  SUPPRESSNOTIFYTTDESC  = "Hides all addon messages from being displayed in your chat frame.",
  SUPPRESSNOTIFYTTWARN  = "Broadcast updates will still be received.",
  SUPRESSBIDWHISPTTDESC = "Supresses incoming and outgoing whispers related to bidding while a bid is in progress.",
  SUPRESSBIDWHISPTTWARN = "All other non-bidding related whispers will still be displayed.",
  TABLEQUERYHEADER      = "Guild DKP Table Status",
  TABLEQUERYNONOFFICER  = "Non-Officer Table Status (Online)",
  TABLEQUERYOFFICER     = "Officer Table Status (Online)",
  TABLEQUERYOOD         = "Out of Date",
  TABLEQUERYSENT        = "Querying Guild DKP Table Status",
  TABLEQUERYUTD         = "Up to Date",
  TABLEVIEWS            = "Table Views",
  TAKINGBIDSON          = "Taking bids on",
  TANK                  = "Tank",
  TENSECONDSTOBID       = "10 Seconds left to bid!",
  THISWILLREFUND        = "This will refund",
  TIMEELAPSED           = "Time Elapsed",
  TIMEINTERVALBONUS     = "Time Interval Bonus",
  TIMERSIZE             = "Timer Size",
  TIMERSIZETTDESC       = "Scale of bid/raid timer.",
  TIMERSIZETTWARN       = "Poistion can be adjusted by clicking \"Move Bid Timer\" and dragging it to the desired position.",
  TIMERWARNING          = "Warning: Please ensure you have your DKP Bonus parameters properly set. These can be set in the above \"Interval\" and \"Bonus\" boxes, as well as all \"Default DKP Award Values\" in the \"Options\" tab below. It is recommended you set these values and broadcast them to all officers via the DKP Modes window (accessible with \"/dkp modes\" or the button in the \"Options\" tab prior to using.",
  TO                    = "to",
  TOBID                 = "to bid",
  TOBIDROLLRANGE        = "To bid use /random. Your expected range can be seen on the DKP table or by using",
  TOBIDUSE              = "To bid use",
  TODKPLIST             = "to the DKP list?",
  TOOMANYPLAYERSSELECT  = "Too many players selected.",
  TORAID                = "to Raid",
  TOSEND                = "to send",
  TOSTANDBYLIST         = "to Standby List",
  TOTALDKP              = "Total DKP",
  TOTALDKPAWARD         = "Total DKP Awarded",
  TOTALMONDKPUSERS      = "Total MonDKP Users",
  TOWITHDRAWBID         = "to withdraw your bid.",
  TRINKET               = "Trinket",
  TTHISTORYCOUNT        = "Tooltip History Count",
  TTHISTORYCOUNTTTDESC  = "Number of loot/dkp history entries listed in tooltip.",
  TWOHANDED             = "Two-Handed",
  TWOHANDEDWEAPONS      = "Two-Handed Weapons",
  UNAUTHUPDATE1         = "has attempted to broadcast modified tables. He is not a part of your whitelisted officers.",
  UNAUTHUPDATE2         = "has attempted to broadcast modified tables. He is not a designated officer in your guild.",
  UNEXCUSEDABSENCE      = "Unexcused Absence",
  UNEXCUSEDTTDESC       = "Penalty for unexcused absence from raid.",
  UNEXCUSEDTTWARN       = "Should be a negative number.",
  UPTODATE              = "up-to-date",
  USE                   = "Use",
  USEPERCENTAGE         = "Use Percentage",
  USEPERCFORROLLS       = "Use Percentage for Rolls",
  USEPERCROLLSTTDESC    = "Converts above roll ranges to % of players DKP. IE: A player with 1000 dkp, with the above set to 70% - 100% will be expected to use\n/random 700-1000",
  USEPERCROLLSTTWARN    = "If this is checked, please only use numbers between 0 and 100.",
  VALUE                 = "value",
  VERSION               = "Version",
  VIEWALL               = "View All",
  VIEWCORERAID          = "View Core Raiders",
  VIEWRAID              = "View Raid",
  VIEWRAIDSTANDBY       = "View Raid and Standby",
  VIEWS                 = "Views",
  VIEWSTANDBY           = "View Standby List",
  VIEWWHITELISTBTN      = "View Whitelist",
  VIEWWHITELISTTTDESC   = "Selects all officers on your DKP list that are whitelisted.",
  VISIBLE               = "visible",
  WARNING               = "WARNING",
  WEEKLYDECAY           = "Weekly Decay",
  WEEKLYDECAYTTDESC     = "Amount of DKP you wish to reduce DKP entries by as a weekly decay. This should be a positive number. If \"Selected Players Only\" is not selected below, it will apply to all entries.",
  WEEKLYDECAYTTWARN     = "Warning: Can not be undone.",
  WEEKLYDKPDECAY        = "Weekly DKP Decay",
  WHISPER               = "Whisper",
  WHISPERCMDSHELP       = "Whisper Commands (To Designated Officers)",
  WHITELISTBROADCASTED  = "Whitelist Broadcasted",
  WHITELISTEMPTY        = "Your whitelist is empty.",
  WHITELISTHEADER       = "Whitelist Settings |CFF444444(Leader Only) (Alpha)|r\n\nIt is strongly advised you only use this whitelist setting if you wish to restrict what officers require permissions. If you want all officers to have permissions, ignore this settings feature entirely. Use with caution. (If applying these settings causes problems, open your \\WTF\\Accounts\\ACCOUNT_NAME\\SavedVariables\\MonolithDKP.lua file with a text editor and delete the MonDKP_Whitelist table near the bottom.)",
  WITH                  = "with",
  WON                   = "won",
  WONBY                 = "won by",
  YES                   = "Yes",
  YOUCURRENTLYHAVE      = "You currently have",
  YOURBID               = "Your bid",
  YOURBIDOF             = "Your bid of",
  YOURTABLESARECURR     = "Your tables are currently",
  ZEROSUMBALANCE        = "Zero Sum Balance",
  ZEROSUMBALANCETTDESC  = "Automatically accumulates all DKP spent by raiders to be distributed after loot has all been purchased.",
  ZEROSUMBANK           = "Zero Sum Bank",
  ZEROSUMDESCRIPTION    = "With Zero Sum DKP, items can either have a static value or be bid upon. When a player wins an item for the bid or cost of the item, that DKP is deducted from them and distributed evenly among the raid. It is recommmended to use decimal places via \"DKP Rounding\" option as rounded integers could cause inflation or lost DKP. That would distribute 9 points above the cost.\n\nEx: |cffa335ee|Hitem:18824::::::::120:577::::::|h[Magma Tempered Boots]|h|r drops and has a static cost of 30 DKP. Player A wins the bid by having the most DKP (or distributed at raid leaders discretion if a tie) and their DKP is reduced by 30. Then each raid member receives 0.75 DKP.",
  ZEROSUMHEAD           = "Zero Sum",
  ZEROSUMITEMCOST       = "Zero Sum Item Costs",
  ZEROSUMITEMCOSTTTDESC = "Select the type of item cost you wish to use. Static gives items a defined cost. While Minimum Bid allows players to submit a bid which defines the cost while you set a minimum bid threshold.",
  ZONE                  = "Zone",

  CHANGELOG1            = "https://www.youtube.com/watch?v=tT4eN2ux76E",
  CHANGELOG2            = "",
  CHANGELOG3            = "",
  CHANGELOG4            = "",
  CHANGELOG5            = "",
  CHANGELOG6            = "",
  CHANGELOG7            = "",
  CHANGELOG8            = "",
  CHANGELOG9            = "",
  CHANGELOG10           = "",
}